% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_split_plot.R
\name{anova_spd}
\alias{anova_spd}
\title{============================================================================
SPLIT PLOT DESIGN ANALYSIS FUNCTIONS (All Variations)
Package: aridagri
Author: Lalit Kumar Rolaniya
ICAR-Indian Institute of Pulses Research, Regional Centre, Bikaner
============================================================================
Split Plot Design ANOVA (Standard)}
\usage{
anova_spd(
  data,
  response,
  main_plot,
  sub_plot,
  replication,
  posthoc = "lsd",
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the experimental data}

\item{response}{Name of the response variable}

\item{main_plot}{Name of main plot factor}

\item{sub_plot}{Name of sub-plot factor}

\item{replication}{Name of replication/block factor}

\item{posthoc}{Post-hoc test method}

\item{alpha}{Significance level}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA table, means, and post-hoc results
}
\description{
Performs complete ANOVA for Split Plot Design with proper error terms for 
main plot and sub-plot factors. Includes all standard post-hoc comparisons.
}
\examples{
data <- data.frame(
  rep = rep(1:3, each = 12),
  irrigation = rep(rep(c("I1", "I2", "I3"), each = 4), 3),
  variety = rep(c("V1", "V2", "V3", "V4"), 9),
  yield = rnorm(36, 1200, 150)
)
anova_spd(data, response = "yield", main_plot = "irrigation", 
          sub_plot = "variety", replication = "rep")

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
