% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_file_comparison.R
\name{file_comparison}
\alias{file_comparison}
\title{Compare the contents of two WebAnno tsv files.}
\usage{
file_comparison(
  input,
  method = "kripp",
  null_category = TRUE,
  log = NULL,
  verbose = TRUE
)
}
\arguments{
\item{input}{list of character or WebAnnoTSV. The contents of WebAnno TSV v3.3 files 
as created by \code{\link{webanno_open}} or a set of paths leading to them.}

\item{method}{character. A choice of "absolute" and "kripp".}

\item{null_category}{logical. In cases where one annotator labels something and the remaining do not, should it be assigned a category or be set as \code{NA}?}

\item{log}{character. Optional path to save the}

\item{verbose}{boolean. Print the output of the function at the end.}
}
\value{
list. Later should be a dataframe with differences per block in the text.
}
\description{
Detect differences between two WebAnno files of the same text 
for annotation monitoring.
}
\details{
Right now, finds out the total sum of differences between all aspects of a given text.
Method \code{kripp} calculates the Krippendorf Alpha, "a reliability coefficient 
developed to measure the agreement among observers, coders, judges, raters, 
or measuring instruments drawing distinctions among typically unstructured 
phenomena or assign computable values to them. alpha emerged in content 
analysis but is widely applicable wherever two or more methods of generating 
data are applied to the same set of objects, units of analysis, or items and 
the question is how much the resulting data can be trusted to represent 
something real" (Krippendorf, 2011).
}
\examples{
example = arete_data("annotations")

file_comparison(example)
}
\references{
Klaus Krippendorff (2011). Computing Krippendorff’s Alpha-Reliability. Departmental Papers (ASC). University of Pennsylvania. \url{https://repository.upenn.edu/handle/20.500.14332/2089}
}
