% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geoprocessing-types.R
\name{gp_params}
\alias{gp_params}
\alias{parse_gp_feature_record_set}
\alias{as_gp_feature_record_set}
\alias{parse_gp_record_set}
\alias{as_record_set}
\alias{as_gp_raster_layer}
\alias{gp_linear_unit}
\alias{as_gp_linear_unit}
\alias{parse_gp_linear_unit}
\alias{gp_areal_unit}
\alias{as_gp_areal_unit}
\alias{parse_gp_areal_unit}
\alias{as_gp_date}
\alias{parse_gp_date}
\alias{as_spatial_reference}
\alias{parse_spatial_reference}
\title{Geoprocessing Parameter Types}
\usage{
parse_gp_feature_record_set(json)

as_gp_feature_record_set(x)

parse_gp_record_set(json)

as_record_set(x)

as_gp_raster_layer(x)

gp_linear_unit(distance = integer(0), units = character(0))

as_gp_linear_unit(x)

parse_gp_linear_unit(json)

gp_areal_unit(area = integer(0), units = character(0))

as_gp_areal_unit(x)

parse_gp_areal_unit(json)

as_gp_date(x)

parse_gp_date(json)

as_spatial_reference(x)

parse_spatial_reference(json)
}
\arguments{
\item{json}{raw json to parse}

\item{x}{the object to convert into json}

\item{distance}{a scalar number of the distance.}

\item{units}{the unit of the measurement. Must be one of "esriUnknownAreaUnits", "esriSquareInches", "esriSquareFeet", "esriSquareYards", "esriAcres", "esriSquareMiles", "esriSquareMillimeters", "esriSquareCentimeters", "esriSquareDecimeters", "esriSquareMeters", "esriAres", "esriHectares", "esriSquareKilometers", "esriSquareInchesUS", "esriSquareFeetUS", "esriSquareYardsUS", "esriAcresUS", "esriSquareMilesUS".}

\item{area}{a scalar number of the measurement.}
}
\description{
Functions for converting R objects to and from ArcGIS geoprocessing parameter
types. These functions handle the serialization and parsing of various data
types used in ArcGIS geoprocessing services.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This package provides support for the following geoprocessing parameter types:
\subsection{Implemented Types}{
\itemize{
\item \strong{GPFeatureRecordSetLayer}: Feature collections with geometry and attributes
\item \strong{GPRecordSet}: Tabular data without geometry
\item \strong{GPRasterDataLayer}: Raster datasets from Portal items, Image Servers, or URLs
\item \strong{GPLinearUnit}: Linear distance measurements with units
\item \strong{GPArealUnit}: Area measurements with units
\item \strong{GPDate}: Date/time values in milliseconds since epoch
\item \strong{GPSpatialReference}: Coordinate reference systems
}
}

\subsection{Not Yet Implemented}{

The following types are planned for future implementation:
\itemize{
\item \strong{GPField}: Field definitions with name, type, and properties
\item \strong{GPMultiValue}: Arrays of values for a single data type
\item \strong{GPValueTable}: Flexible table-like objects with rows and columns
\item \strong{GPComposite}: Parameters that accept multiple data types
\item \strong{GPEnvelope}: Bounding box extents (use \code{as_extent()} for GPExtent)
}
}
}
\section{Usage Patterns}{


Most functions follow a consistent pattern:
\itemize{
\item \verb{as_gp_*()}: Convert R objects to geoprocessing parameter JSON
\item \verb{parse_gp_*()}: Parse geoprocessing response JSON to R objects
\item Constructor functions (e.g., \code{gp_linear_unit()}, \code{gp_areal_unit()}) create typed S7 objects
}
}

\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Create a linear unit
distance <- gp_linear_unit(distance = 100, units = "esriMeters")

# Convert spatial data to feature record set
as_gp_feature_record_set(my_sf_data)

# Parse a geoprocessing response
parse_gp_feature_record_set(response_json)
}\if{html}{\out{</div>}}
}

\examples{
# create a feature record set
fset <- as_gp_feature_record_set(iris[1,])
fset

# create fake gp feature record set to parse
fset_list <- list(
  list(
    dataType = "GPFeatureRecordSetLayer",
    paramName = "example",
    value = as_featureset(iris[1,])
  )
)

# create the json
json <- yyjsonr::write_json_str(fset_list, auto_unbox = TRUE)

# parse the record set json
parse_gp_feature_record_set(json)

# linear units
lu <- gp_linear_unit(10, "esriMeters")
lu
as_gp_linear_unit(lu)

# areal units
au <- gp_areal_unit(10, "esriSquareMeters")
au

as_gp_areal_unit(au)

# dates
json <- r"({
  "paramName": "Output_Date",
  "dataType": "GPDate",
  "value": 1199145600000
})"

parse_gp_date(json)
}
\references{
\href{https://developers.arcgis.com/rest/services-reference/enterprise/gp-data-types/}{API Documentation}
}
\seealso{
Other geoprocessing: 
\code{\link{arc_form_params}()},
\code{\link{arc_gp_job}},
\code{\link{arc_job_status}()}
}
\concept{geoprocessing}
