% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formating.R
\name{apa_p}
\alias{apa_p}
\title{p-value in APA format}
\usage{
apa_p(
  p,
  inline = FALSE,
  markdown = TRUE,
  min_digits = 2,
  max_digits = 3,
  align = FALSE
)
}
\arguments{
\item{p}{probability}

\item{inline}{If TRUE (default), returns statistic (e.g.,e p = .04), otherwise just the number (e.g., .04)}

\item{markdown}{By default, outputs text compatible with markdown if TRUE, otherwise prints plain text compatible with latex.}

\item{min_digits}{minimum number of digits to round to. Default is 2.}

\item{max_digits}{maximum number of digits to round to. Default is 3.}

\item{align}{decimal alignment if \code{TRUE}}
}
\value{
character vector
}
\description{
p-value in APA format
}
\examples{
# Values less than .001 are <.001
apa_p(.0002)
# Values between .001 and .01 are rounded to 3 digits
apa_p(.002)
# Values between .01 and .995 are rounded to 2 digits
apa_p(.02)#'
apa_p(.22)
apa_p(.994)
# Values above .995 are >.99
apa_p(.999)
# Rounding to 3 digits
apa_p(.2341, min_digits = 3)
apa_p(.0123, min_digits = 3)
apa_p(.00123, min_digits = 3)
apa_p(.000123, min_digits = 3)
apa_p(.991, min_digits = 3)
apa_p(.9991, min_digits = 3)
apa_p(.9995, min_digits = 3)
}
