% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{mergeAnalyzer}
\alias{mergeAnalyzer}
\title{Analyze data for merging}
\usage{
mergeAnalyzer(x, y, round.digit = 2, ...)
}
\arguments{
\item{x}{left data to merge}

\item{y}{right data to merge}

\item{round.digit}{integer indicating the number of decimal places to be used}

\item{...}{other parameters needs to be passed to merge function}
}
\value{
Returns merged data with same class as that of input data.
Prints summary of data retained after merging.
The summary has 6 columns:
\itemize{
 \item Column: Number of rows and union of column names of numeric columns
 in both the data
 \item x, y: Sum of columns in both table
 \item Merged: Sum of columns in merged data
 \item remainingWRTx: ratio of remaining data in merged data after merging.
 example - 0.5 means that 50% data was dropped after merging (probably in case
 of inner join). 1.5 means value became 150% of original sum because of some
 duplicates present in data
 \item remainingWRTy: same as above, but for y table
}
}
\description{
\code{mergeAnalyzer} analyzes the data drop after merge
}
\details{
Prints the summary of data retained after merge and returns the merged data.
This function uses data.table (if the package is installed) for faster data
merge
}
\examples{
# Creating two tables to merge
A <- data.frame(id = c("A", "A", "B", "D", "B"),
                valA = c(30, 83, 45, 2, 58))

B <- data.frame(id = c("A", "C", "A", "B", "C", "C"),
                valB = c(10, 20, 30, 40, 50, 60))

mergeAnalyzer(A, B, allow.cartesian = TRUE, all = FALSE)

}
