\name{panel.Loess}
\alias{panel.Loess}
\title{Loess smooths to stratigraphic diagrams}
\description{
  A modified version of \code{\link[lattice]{panel.loess}}, for drawing Loess
  smooths on stratigraphic diagrams.
}
\usage{
panel.Loess(x, y,
            span = 1/3, degree = 1,
            family = c("symmetric","gaussian"),
            evaluation = 50,
            lwd = plot.line$lwd,
            lty = plot.line$lty,
            col,
            col.line = plot.line$col,
            type,
            \dots)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x, y}{variables defining the contents of the panel.}
  \item{span, degree, family, evaluation}{arguments passed to
    \code{\link{loess.smooth}}, for which \code{panel.Loess} is a
    wrapper.}
  \item{lwd, lty, col, col.line}{graphical parameters.}
  \item{type}{for compatibility with \code{\link[lattice]{panel.loess}}, but is
    ignored within the function.}
  \item{\dots}{graphical parameters can be supplied. Color can usually
    be specified by \code{col}, \code{col.line}, the latter overriding
    the first for lines.}
}
\details{
  The standard panel function \code{\link[lattice]{panel.loess}} treats the data
  as the x-axis acting as the time component. For stratigraphic plots
  where time flows along the y-axis, we want the smoother to be fitted
  with the x-axis data as the response and the time component (y-axis)
  as the predictor.

  This modified version of \code{\link[lattice]{panel.loess}} flips the two axes
  to produce the desired effect. Note also that it does not have
  argument \code{horizontal} as this is not required or supported by
  \code{\link{Stratiplot}}. In other respects, \code{panel.Loess} is
  equivalent to the lattice panel function \code{\link[lattice]{panel.loess}}.

  User should note that warnings can be generated by the fitting
  function if span is set too small for species with few
  observations. In such cases, the user is directed to the help page for
  \code{\link{loess.smooth}}, but increasing \code{span} slightly can
  often stop the warnings.
}
\author{Gavin L. Simpson, slightly modified from the Lattice function
  \code{\link[lattice]{panel.loess}} by Deepayan Sarkar.}
%\note{ ~~further notes~~ 
%
% ~Make other sections like Warning with \section{Warning }{....} ~
%}
\seealso{\code{\link{loess.smooth}}, \code{\link[lattice]{panel.loess}}.}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{hplot}
