% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EV.AMMI.R
\name{EV.AMMI}
\alias{EV.AMMI}
\title{Averages of the Squared Eigenvector Values}
\usage{
EV.AMMI(model, n, alpha = 0.05, ssi.method = c("farshadfar", "rao"), a = 1)
}
\arguments{
\item{model}{The AMMI model (An object of class \code{AMMI} generated by
\code{\link[agricolae]{AMMI}}).}

\item{n}{The number of principal components to be considered for computation.
The default value is the number of significant IPCs.}

\item{alpha}{Type I error probability (Significance level) to be considered
to identify the number of significant IPCs.}

\item{ssi.method}{The method for the computation of simultaneous selection
index. Either \code{"farshadfar"} or \code{"rao"} (See
\code{\link[ammistability]{SSI}}).}

\item{a}{The ratio of the weights given to the stability components for
computation of SSI when \code{method = "rao"} (See
\code{\link[ammistability]{SSI}}).}
}
\value{
A data frame with the following columns:  \item{EV}{The EV values.}
  \item{SSI}{The computed values of simultaneous selection index for yield
  and stability.} \item{rEV}{The ranks of EV values.} \item{rY}{The ranks of
  the mean yield of genotypes.} \item{means}{The mean yield of the
  genotypes.}

  The names of the genotypes are indicated as the row names of the data
  frame.
}
\description{
\code{EV.AMMI} computes the Sums of the Averages of the Squared Eigenvector
Values (EV) \insertCite{zobel_stress_1994}{ammistability} considering all
significant interaction principal components (IPCs) in the AMMI model. Using
EV, the Simultaneous Selection Index for Yield and Stability (SSI) is also
calculated according to the argument \code{ssi.method}. \loadmathjax
}
\details{
The Averages of the Squared Eigenvector Values (\mjseqn{EV})
\insertCite{zobel_stress_1994}{ammistability} is computed as follows:

\mjsdeqn{EV = \sum_{n=1}^{N'}\frac{\gamma_{in}^2}{N'}}

Where, \mjseqn{N'} is the number of significant IPCs (number of IPC that were
retained in the AMMI model via F tests); and \mjseqn{\gamma_{in}} is the
eigenvector value for \mjseqn{i}th genotype.
}
\examples{
library(agricolae)
data(plrv)

# AMMI model
model <- with(plrv, AMMI(Locality, Genotype, Rep, Yield, console = FALSE))

# ANOVA
model$ANOVA

# IPC F test
model$analysis

# Mean yield and IPC scores
model$biplot

# G*E matrix (deviations from mean)
array(model$genXenv, dim(model$genXenv), dimnames(model$genXenv))

# With default n (N') and default ssi.method (farshadfar)
EV.AMMI(model)

# With n = 4 and default ssi.method (farshadfar)
EV.AMMI(model, n = 4)

# With default n (N') and ssi.method = "rao"
EV.AMMI(model, ssi.method = "rao")

# Changing the ratio of weights for Rao's SSI
EV.AMMI(model, ssi.method = "rao", a = 0.43)

}
\references{
\insertRef{zobel_stress_1994}{ammistability}
}
\seealso{
\code{\link[agricolae]{AMMI}}, \code{\link[ammistability]{SSI}}
}
