% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCoord.R
\name{getCoord}
\alias{getCoord}
\title{Get coordinate from location}
\usage{
getCoord(
  address,
  key = NULL,
  city = NULL,
  sig = NULL,
  output = "data.table",
  callback = NULL,
  keep_bad_request = TRUE,
  ...
)
}
\arguments{
\item{address}{Required.\cr
Structured address information. \cr
Rules: Country/Region, Province/State,
City, County/District, Town, Country, Road, Number, Room, Building.}

\item{key}{Optional.\cr
Amap Key. \cr
Applied from 'AutoNavi' Map API official
website\url{https://lbs.amap.com/dev/}}

\item{city}{Optional.\cr
Specify the City. \cr
Support: city in Chinese, full pinyin, citycode,
adcode\url{https://lbs.amap.com/api/webservice/download}.\cr
The default value is NULL which will search country-wide.
The default value is NULL}

\item{sig}{Optional.\cr
Digital Signature.\cr
How to use this argument?
Please check here{https://lbs.amap.com/faq/account/key/72}}

\item{output}{Optional.\cr
Output Data Structure. \cr
Support JSON, XML and data.table. The default value is data.table.}

\item{callback}{Optional.\cr
Callback Function. \cr
The value of callback is the customized function.
Only available with JSON output.
If you don't understand, it means you don't need it, just like me.}

\item{keep_bad_request}{Optional.\cr
Keep Bad Request to avoid breaking a workflow,
especially meaningful in a batch request}

\item{...}{Optional.\cr
For compatibility only}
}
\value{
Returns a JSON, XML or data.table of results
containing detailed geocode information.
See \url{https://lbs.amap.com/api/webservice/guide/api/georegeo}
for more information.
}
\description{
Get coordinate from location
}
\examples{
\dontrun{
library(amapGeocode)

# Before the `getCoord()` is executed,
# the token should be set by `option(amap_key = 'key')`
# or set by key argument in `getCoord()`

# Get geocode as a data.table
getCoord("IFS Chengdu")
# Get geocode as a XML
getCoord("IFS Chengdu", output = "XML")
}

}
\seealso{
\code{\link{extractCoord}}
}
