% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcalendar.R
\name{cal_events}
\alias{cal_events}
\title{Calendar events}
\usage{
cal_events(x, ..., year = NULL, observed = FALSE)
}
\arguments{
\item{x}{\verb{[rcalendar]}

An rcalendar.}

\item{...}{These dots are for future extensions and must be empty.}

\item{year}{\verb{[integer]}

An integer vector of years to filter for.}

\item{observed}{\verb{[FALSE / TRUE]}

When filtering for specific \code{year}s, should the \emph{observed} date of the
holiday be used for filtering purposes? If \code{FALSE}, the \emph{actual} date of
the holiday will be used, i.e. the date before any observance adjustments
created by \code{\link[=hol_observe]{hol_observe()}} have been applied, which is typically desired
when filtering for a year's worth of holidays. See the examples.}
}
\value{
A two column data frame:
\itemize{
\item \code{name} is a character vector of holiday names.
\item \code{date} is a Date vector of holiday event dates.
}
}
\description{
\code{cal_events()} returns a data frame of holiday name / event date pairs for
a calendar. It is similar to \code{\link[=alma_events]{alma_events()}}, but returns information about
the name of the holiday and has specialized behavior related to observed
dates when filtering by \code{year}.
}
\examples{
on_weekends <- weekly() \%>\%
  recur_on_weekends()

# New Year's Day, observed on the nearest weekday if it falls on a weekend
on_new_years <- hol_new_years_day() \%>\%
  hol_observe(on_weekends, adj_nearest)

# Christmas, observed on the nearest weekday if it falls on a weekend
on_christmas <- hol_christmas() \%>\%
  hol_observe(on_weekends, adj_nearest)

cal <- rcalendar(on_new_years, on_christmas)
cal

# In 2010, Christmas fell on a Saturday and was adjusted backwards
cal_events(cal, year = 2010)

# In 2011, New Year's fell on a Saturday and was adjusted backwards.
# Note that the returned date is in 2010, even though we requested holidays
# for 2011, because most people would consider the actual New Year's date of
# 2011-01-01 part of the 2011 set of holidays, even though it was observed in
# 2010.
cal_events(cal, year = 2011)

# If you want to filter by the observed date, set `observed = TRUE`, which
# will move the New Year's Day that was observed in 2010 to the 2010 result
cal_events(cal, year = 2010, observed = TRUE)
cal_events(cal, year = 2011, observed = TRUE)
}
