% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/resample.R
\docType{methods}
\name{resample_down}
\alias{resample_down}
\alias{resample_down-method}
\alias{resample_down,numeric,numeric-method}
\alias{resample_down,ANY,missing-method}
\title{Downsample}
\usage{
resample_down(x, y, ...)

\S4method{resample_down}{numeric,numeric}(x, y, by)

\S4method{resample_down}{ANY,missing}(x, y, by)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{by}{An \code{\link{integer}} specifying the downsampling factor.}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Downsample
}
\examples{
## X-ray diffraction
data("XRD")

## Plot spectrum
plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")

## Bin by 3
XRD_bin_mean <- resample_bin(XRD, by = 3, f = mean)
XRD_bin_min <- resample_bin(XRD, by = 3, f = min)

plot(XRD, type = "l", xlim = c(25, 35),
     xlab = expression(2*theta), ylab = "Count")
lines(XRD_bin_mean, type = "l", col = "red")
lines(XRD_bin_min, type = "l", col = "green")

## Downsample by 10
XRD_down <- resample_down(XRD, by = 10)

plot(XRD, type = "l", xlim = c(20, 40),
     xlab = expression(2*theta), ylab = "Count")
lines(XRD_down, type = "l", col = "red")

## Linearly interpolate
XRD_approx <- resample_interpolate(XRD, from = 20, to = 40, by = 0.02)

plot(XRD, type = "l", xlim = c(20, 40),
     xlab = expression(2*theta), ylab = "Count")
lines(XRD_approx, type = "l", col = "red")
}
\seealso{
Other resampling methods: 
\code{\link{resample_bin}()},
\code{\link{resample_interpolate}()}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
