% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.R
\name{sampler.mixture}
\alias{sampler.mixture}
\title{Sampler for a mixture distribution.}
\usage{
\method{sampler}{mixture}(x, ...)
}
\arguments{
\item{x}{A \code{mixture} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(n = 1, ...)} returning a numeric
vector of length \code{n}.
}
\description{
Returns a function that draws samples from the mixture by first
selecting a component according to the mixing weights, then
sampling from the selected component.
}
\examples{
m <- mixture(list(normal(0, 1), normal(5, 1)), c(0.5, 0.5))
s <- sampler(m)
set.seed(42)
s(6)
}
