% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.R
\name{mixture}
\alias{mixture}
\title{Construct a mixture distribution.}
\usage{
mixture(components, weights)
}
\arguments{
\item{components}{A non-empty list of \code{dist} objects.}

\item{weights}{A numeric vector of non-negative mixing weights that
sum to 1 (within tolerance \code{1e-10}).  Must have the same
length as \code{components}.}
}
\value{
A \code{mixture} object with appropriate class hierarchy.
}
\description{
Creates an S3 object representing a finite mixture distribution.
The density is \eqn{f(x) = \sum_{k=1}^{K} w_k f_k(x)} where
\eqn{f_k} are the component densities and \eqn{w_k} are the mixing
weights.
}
\details{
The class hierarchy is determined by the components: if all components
are univariate (or multivariate, continuous, discrete), the mixture
inherits those classes as well.
}
\examples{
m <- mixture(
  components = list(normal(0, 1), normal(5, 2)),
  weights = c(0.3, 0.7)
)
mean(m)
vcov(m)
format(m)
}
