% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_dist.R
\name{hazard.weibull_dist}
\alias{hazard.weibull_dist}
\title{Hazard function for a Weibull distribution.}
\usage{
\method{hazard}{weibull_dist}(x, ...)
}
\arguments{
\item{x}{A \code{weibull_dist} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(t, log = FALSE)} returning the hazard
(or log-hazard) at \code{t}.
}
\description{
Returns a function that evaluates the Weibull hazard rate
\eqn{h(t) = (shape/scale)(t/scale)^{shape-1}} for \eqn{t > 0}.
}
\examples{
x <- weibull_dist(shape = 2, scale = 3)
h <- hazard(x)
h(1)
h(3)
}
