% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{expectation_data}
\alias{expectation_data}
\title{Function used for computing expectations given data (e.g., from an MC
simulation or bootstrap). it expects a matrix, or something that can be
coerced to a matrix (e.g., a data frame). it also expects a function \code{g} to
apply to each row of the data, and returns the expectation of \code{g} under the
empirical distribution of the data. it also returns a confidence interval for
the expectation, and the number of samples used to compute the expectation.}
\usage{
expectation_data(
  data,
  g = function(x) x,
  ...,
  compute_stats = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{data}{a matrix of data}

\item{g}{a function to apply to each row of the data}

\item{...}{additional arguments to pass to \code{g}}

\item{compute_stats}{whether to compute CIs for the expectations}

\item{alpha}{the confidence level for the confidence interval for each
component of the expectation (if compute_stats is TRUE)}
}
\value{
if compute_stats is TRUE, then a list with the following components:
value - The estimate of the expectation
ci    - The confidence intervals for each component of the expectation
n     - The number of samples
otherwise, just the value of the expectation.
}
\description{
example: expectation_data(D, function(x) (x-colMeans(D)) \%*\% t(x-colMeans(D)))
computes the covariance of the data D, except the matrix structure is lost
(it's just a vector, which can be coerced back to a matrix if needed).
}
