% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel-examples.R
\name{pord_spread}
\alias{pord_spread}
\title{Compare Spread of Vectors (Preorder)}
\usage{
pord_spread(x, y, incompatible_lengths = NA)
}
\arguments{
\item{x}{numeric vector}

\item{y}{numeric vector of the same length as \code{x}}

\item{incompatible_lengths}{single logical value,
value to return iff lengths of \code{x} and \code{y} differ}
}
\value{
The function returns a single logical value,
which states whether \code{x} has no greater
spread than \code{y}
}
\description{
This function determines whether
one numeric vector has not greater spread than the
other
}
\details{
We say that \bold{x} of size \eqn{n}
is of \emph{no greater spread} than \bold{y}
iff for all \eqn{i,j=1,\dots,n} such
that \eqn{x_i>x_j} it holds \eqn{x_i-x_j\le y_i-y_jll
}.
Such a preorder is used in the definition of
a spread measure (see Gagolewski, 2015).

Note that the class of dispersion functions includes
e.g. the sample variance (see \code{\link{var}}),
standard veriation (see  \code{\link{sd}}),
range (see  \code{\link{range}} and then  \code{\link{diff}}),
interquartile range (see  \code{\link{IQR}}),
median absolute deviation (see \code{\link{mad}}).
}
\references{
Gagolewski M., Spread measures and their relation to aggregation functions,
\emph{European Journal of Operational Research} 241(2), 2015, pp. 469--477.

Gagolewski M., Data Fusion: Theory, Methods, and Applications,
   Institute of Computer Science, Polish Academy of Sciences, 2015, 290 pp.
   isbn:978-83-63159-20-7
}
\seealso{
Other binary_relations: 
\code{\link{check_comonotonicity}()},
\code{\link{pord_nd}()},
\code{\link{pord_weakdom}()},
\code{\link{rel_graph}()},
\code{\link{rel_is_antisymmetric}()},
\code{\link{rel_is_asymmetric}()},
\code{\link{rel_is_cyclic}()},
\code{\link{rel_is_irreflexive}()},
\code{\link{rel_is_reflexive}()},
\code{\link{rel_is_symmetric}()},
\code{\link{rel_is_total}()},
\code{\link{rel_is_transitive}()},
\code{\link{rel_reduction_hasse}()}
}
\concept{binary_relations}
\concept{spread_measures}
