% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aftsem.R
\name{aftsem}
\alias{aftsem}
\title{Accelerated Failure Time Semiparametric Model}
\usage{
aftsem(
  formula,
  data,
  control = aftsem.control(),
  method = "buckley",
  binit = "auto",
  ties = NULL,
  na.action = na.omit,
  subset = NULL,
  resample = 0,
  ...
)
}
\arguments{
\item{formula}{A formula expression, of the form \code{response ~ predictors}. Response must be a Surv object}

\item{data}{An optional data.frame in which to interpret the variables in the \code{formula}.}

\item{control}{Control parameters for the AFT model.}

\item{method}{A character string specifying the method to be used (buckley,jin,gehan,gehan-heller,gehan-poly).}

\item{binit}{Initial values for the regression parameters.}

\item{ties}{A method to handle ties in the failure times. If ties = NULL only warning will be printed. If ties = jitter, the data will be augumented}

\item{na.action}{A method to deal with missing values (na.fail)}

\item{subset}{An optional vector specifying a subset of observations to be used in the fitting process.}

\item{resample}{Number of resamples for variance estimation for gehan and jin methods.}

\item{...}{Additional arguments.}
}
\value{
A list representing the fit
 - `call`: Call of the function
 - `cnames`: Column names
 - `method`: Method of estimation
 - `nobs`: Number of observations
 - `censored`: Number of censored observations
 - `betafirst`: Initial beta
 - `epsilon`: Epsilon in convergence criterion
 - `max_iterations`: Max iterations for buckley and jin method
 - `resample`: Resample number
 - `objects from aftsem.fit`: All the object from fit function
}
\description{
Accelerated Failure Time Semiparametric Model
}
\examples{
# Generating example data
library(survival)
set.seed(123) # for reproducibility
n <- 100 # number of observations
Z <- matrix(rnorm(n*2), ncol = 2) # two covariates
beta <- c(0.5, -0.25) # true coefficients
times <- exp(Z \%*\% beta + rnorm(n)) # simulated survival times
censoring <- runif(n,0,30)
observed_times <- times
delta <- 1 * (times<=censoring)

# Fit the model


fit <- aftsem(Surv(log(observed_times), delta) ~ Z[,1] + Z[,2],
              method = "buckley",
              binit = "auto",
              ties = "NULL",
              na.action = na.omit,
              subset = NULL
)

# Print the summary
summary(fit)


}
