% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Descriptive.R
\name{show.saliency}
\alias{show.saliency}
\title{Print summary of saliency analysis}
\usage{
show.saliency(
  res,
  ncol_x = Kx,
  ncol_y = Ky,
  labels_x = paste0("Trait ", 1:Kx),
  labels_y = paste0("Trait ", 1:Ky),
  pr = 0.05
)
}
\arguments{
\item{res}{A list corresponding to the output of
\code{\link{estimate.affinity.matrix}},
\code{\link{estimate.affinity.matrix.lowrank}} or
\code{\link{estimate.affinity.matrix.unipartite}}.}

\item{ncol_x}{An integer indicating the number of singular vector to print
for men. The function prints the first \code{ncol_x} singular vectors.
Defaults to \code{ncol(U)}.}

\item{ncol_y}{An integer indicating the number of singular vector to print
for women. The function prints the first \code{ncol_y} singular vectors.
Defaults to \code{ncol(V)}.}

\item{labels_x}{A vector of strings indicating the names of men's matching
variables. Defaults to \code{"Trait k"} for every \code{k} matching
variable.}

\item{labels_y}{A vector of strings indicating the names of women's matching
variables. Defaults to \code{"Trait k"} for every \code{k} matching
variable.}

\item{pr}{A probability indicating the two-tailed significance level required
for an estimated parameter to be printed in boldface. Defaults to 0.05
and can be set to 0 to avoid printing any estimate in boldface.}
}
\value{
The function returns a long string in LaTeX style that can be
processed in the standard LaTeX tabular environment in order to display
the estimates of the vectors of loadings for the first \code{ncol_x}
men's matching factors and the first \code{ncol_y} women's matching
factors.
}
\description{
This function prints the results from the saliency analysis in LaTeX style.
The function returns a list of two elements: \code{U.table} contains the
first \code{ncol_x} vectors of loadings that map men's \code{Kx} observed
traits into the first \code{ncol_x} matching factors; \code{V.table} contains
the first \code{ncol_y} vectors of loadings that map women's \code{Ky}
observed traits into the first \code{ncol_y} matching factors. In both
tables, the last line reports the normalized singular values of the affinity
matrix in descending order.
}
