% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{af_colours}
\alias{af_colours}
\alias{af_dark_blue}
\alias{af_orange}
\alias{af_grey}
\alias{af_pale_grey}
\title{Individual Analysis Function colours}
\format{
An object of class \code{character} of length 1.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.

An object of class \code{character} of length 1.
}
\source{
\href{https://analysisfunction.civilservice.gov.uk/policy-store/data-visualisation-colours-in-charts/}{Government Analysis Function Colours Guidance}
}
\usage{
af_dark_blue

af_orange

af_grey

af_pale_grey
}
\description{
Quick access to individual colours from the Analysis Function colour palettes.
}
\examples{

library(dplyr)
library(ggplot2)

# Example of using af_dark_blue to colour bars
iris \%>\%
  group_by(Species) \%>\%
  summarise(Petal.Width = mean(Petal.Width)) \%>\%
  ggplot() +
  geom_col(
    aes(Species, Petal.Width),
    fill = af_dark_blue
 ) +
  scale_y_continuous(
    expand = expansion(c(0, 0.05))
  ) +
  theme_af()

}
\keyword{datasets}
