% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesopR-package.R, R/data-aesops-tokens.R
\docType{data}
\name{aesops_tokens}
\alias{aesops_tokens}
\title{Tokenized Aesop's Fables}
\format{
A tibble with one row per word token and the following variables:
\describe{
  \item{fable_id}{Character string identifying the source fable.}
  \item{word}{Lowercase word token extracted from the fable text.}
  \item{word_count}{Total number of words in the source fable.}
  \item{source_url}{URL of the original fable text.}
}

A tibble with one row per word token and the following variables:
\describe{
  \item{fable_id}{Character string identifying the source fable.}
  \item{title}{Title of the fable}
  \item{moral}{The moral or lesson associated with the fable.}
  \item{word}{Lowercase word token extracted from the fable text.}
}
}
\usage{
aesops_tokens

aesops_tokens
}
\description{
A tidy token-level dataset derived from \link[aesopR]{aesops_fables}, where
each row represents a single word token from a fable.

A tidy token-level dataset derived from \code{aesops_fables},
where each row represents a single word token from a fable.
}
\details{
This dataset is intended for text analysis tasks such as sentiment analysis,
n-gram modeling, and word frequency analysis.


Tokens were generated using \code{tidytext::unnest_tokens()}.
Stop words have not been removed, allowing users full flexibility in
preprocessing decisions.

This dataset is intended for text analysis tasks such as
sentiment analysis, n-gram modeling, and word frequency analysis.


Tokens were generated using \code{tidytext::unnest_tokens()}.
Stop words have not been removed, allowing users full flexibility
in preprocessing decisions.
}
\examples{
aesops_tokens

if (requireNamespace("dplyr", quietly = TRUE)) {
  aesops_tokens |>
    dplyr::count(word, sort = TRUE)
}

aesops_tokens

aesops_tokens |>
  dplyr::count(word, sort = TRUE)

}
\seealso{
\link[aesopR]{aesops_fables}

\code{\link{aesops_fables}}
}
\keyword{datasets}
