% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TwoStageDesign.R, R/OneStageDesign.R,
%   R/GroupSequentialDesign.R
\name{SurvivalDesign}
\alias{SurvivalDesign}
\alias{SurvivalDesign,TwoStageDesign-method}
\alias{TwoStageDesign,TwoStageDesign-method}
\alias{OneStageDesign,OneStageDesign-method}
\alias{SurvivalDesign,OneStageDesign-method}
\alias{GroupSequentialDesign,GroupSequentialDesign-method}
\alias{SurvivalDesign,GroupSequentialDesign-method}
\title{SurvivalDesign}
\usage{
SurvivalDesign(design, event_rate)

\S4method{SurvivalDesign}{TwoStageDesign}(design, event_rate)

\S4method{TwoStageDesign}{TwoStageDesign}(n1, event_rate)

\S4method{OneStageDesign}{OneStageDesign}(n, event_rate)

\S4method{SurvivalDesign}{OneStageDesign}(design, event_rate)

\S4method{GroupSequentialDesign}{GroupSequentialDesign}(n1, event_rate)

\S4method{SurvivalDesign}{GroupSequentialDesign}(design, event_rate)
}
\arguments{
\item{design}{design that should be converted to a survival design}

\item{event_rate}{probability that a subject in either group will eventually have an event}

\item{n1}{design object to convert (overloaded from \code{TwoStageDesign})}

\item{n}{design object to convert (overloaded from \code{TwoStageDesign})}
}
\value{
Converts any type of design to a survival design
}
\description{
\code{SurvivalDesign} is a function that converts an arbitrary design to a survival design.
}
\examples{
design <- get_initial_design(0.4, 0.025, 0.1)
SurvivalDesign(design, 0.8)

design_os <- get_initial_design(0.4, 0.025, 0.1, type_design = "one-stage")
design_gs <- get_initial_design(0.4, 0.025, 0.1, type_design = "group-sequential")

OneStageDesign(design_os, 0.7)

GroupSequentialDesign(design_gs, 0.8)

}
