% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_projects.R
\name{aw_get_projects}
\alias{aw_get_projects}
\title{Pull a list of projects}
\usage{
aw_get_projects(
  includeType = "all",
  expansion = NULL,
  locale = "en_US",
  limit = 1000,
  page = 0,
  debug = FALSE,
  company_id = Sys.getenv("AW_COMPANY_ID")
)
}
\arguments{
\item{includeType}{Include additional projects not owned by user. The "all" option takes precedence over "shared".
If neither guided, or project is included, both types are returned}

\item{expansion}{Comma-delimited list of additional project metadata fields to include on response.
Available values : reportSuiteName, ownerFullName, modified, tags, accessLevel, externalReferences, definition}

\item{locale}{Locale Default value : en_US}

\item{limit}{Number of results per page. Default value: 1000}

\item{page}{Page number (base 0 - first page is "0")}

\item{debug}{Set to \code{TRUE} to publish the full JSON request(s) being sent to the API to the console when the
function is called. The default is \code{FALSE}.}

\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link[=get_me]{get_me()}} to get a list of available \code{company_id} values.}
}
\value{
A data frame
}
\description{
A list of projects in the account
}
