% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_project_config.R
\name{aw_get_project_config}
\alias{aw_get_project_config}
\title{Pull a project configuration}
\usage{
aw_get_project_config(
  projectId = NULL,
  expansion = NULL,
  locale = "en_US",
  debug = FALSE,
  company_id = Sys.getenv("AW_COMPANY_ID")
)
}
\arguments{
\item{projectId}{The Project id for which to retrieve information}

\item{expansion}{Comma-delimited list of additional project metadata fields to include on response. Available values : reportSuiteName, shares, tags, accessLevel, modified, externalReferences, definition}

\item{locale}{Locale Default value : en_US}

\item{debug}{Set to \code{TRUE} to publish the full JSON request(s) being sent to the API to the console when the
function is called. The default is \code{FALSE}.}

\item{company_id}{Company ID. If an environment variable called \code{AW_COMPANY_ID} exists in \code{.Renviron} or
elsewhere and no \code{company_id} argument is provided, then the \code{AW_COMPANY_ID} value will be used.
Use \code{\link[=get_me]{get_me()}} to get a list of available \code{company_id} values.}
}
\value{
A json string
}
\description{
Returns a project configuration json string
}
