% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{qpWave}
\alias{qpWave}
\title{Find the most likely number of ancestry waves using the qpWave method.}
\usage{
qpWave(
  data,
  left,
  right,
  maxrank = NULL,
  details = FALSE,
  outdir = NULL,
  params = NULL
)
}
\arguments{
\item{data}{EIGENSTRAT data object.}

\item{left, right}{Character vectors of populations labels.}

\item{maxrank}{Maximum rank to test for.}

\item{details}{Return the A, B matrices used in rank calculations?}

\item{outdir}{Where to put all generated files (temporary directory by default).}

\item{params}{Named list of parameters and their values. For instance,
\code{params = list(allsnps = "YES")} or \code{params = list(blgsize = 0.01)}
(or an arbitrary combination of parameters using a list with multiple named
elements).}
}
\value{
Table of rank test results.
}
\description{
Given a set of 'left' populations, estimate the lowest number of necessary
admixture sources related to the set of 'right' populations.
}
\details{
It has been shown (Reich, Nature 2012 - Reconstructing Native American
population history) that if the 'left' populations are mixtures of N
different sources related to the set of 'right' populations, the rank of the
matrix of the form \eqn{f_4(left_i, left_j; right_k, right_l)} will have a
rank N - 1. This function uses the ADMIXTOOLS command qpWave to find the
lowest possible rank of this matrix that is consistent with the data.
}
\examples{
\dontrun{# download example data set and prepare it for analysis
snps <- eigenstrat(download_data(dirname = tempdir()))

# run the qpWave wrapper (detailed description in the tutorial vignette)
result <- qpWave(
     left = c("French", "Sardinian", "Han"),
     right = c("Altai", "Yoruba", "Mbuti"),
     data = snps
)
}

}
