% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmp_vars.R
\name{remove_tmp_vars}
\alias{remove_tmp_vars}
\title{Remove All Temporary Variables Created Within the Current Function Environment}
\usage{
remove_tmp_vars(dataset)
}
\arguments{
\item{dataset}{The input dataset

\describe{
\item{Default value}{none}
}}
}
\value{
The input dataset with temporary variables removed
}
\description{
Remove All Temporary Variables Created Within the Current Function Environment
}
\examples{
library(dplyr, warn.conflicts = FALSE)
dm <- tribble(
  ~DOMAIN,  ~STUDYID,      ~USUBJID,
  "DM",    "STUDY X", "01-701-1015",
  "DM",    "STUDY X", "01-701-1016",
)
dm <- select(dm, USUBJID)
tmp_var <- get_new_tmp_var(dm)
dm <- mutate(dm, !!tmp_var := NA)

## This function creates two new temporary variables which are removed when calling
## `remove_tmp_vars()`. Note that any temporary variable created outside this
## function is **not** removed
do_something <- function(dataset) {
  tmp_var_1 <- get_new_tmp_var(dm)
  tmp_var_2 <- get_new_tmp_var(dm)
  dm \%>\%
    mutate(!!tmp_var_1 := NA, !!tmp_var_2 := NA) \%>\%
    print() \%>\%
    remove_tmp_vars()
}

do_something(dm)
}
\seealso{
\code{\link[=get_new_tmp_var]{get_new_tmp_var()}}
}
\keyword{tmp_vars}
