% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_param_does_not_exist}
\alias{assert_param_does_not_exist}
\title{Asserts That a Parameter Does Not Exist in the Dataset}
\usage{
assert_param_does_not_exist(
  dataset,
  param,
  arg_name = rlang::caller_arg(dataset),
  message = NULL,
  class = "assert_param_does_not_exist",
  call = parent.frame()
)
}
\arguments{
\item{dataset}{A \code{data.frame}

\describe{
\item{Default value}{none}
}}

\item{param}{Parameter code to check

\describe{
\item{Default value}{none}
}}

\item{arg_name}{string indicating the label/symbol of the object being checked.

\describe{
\item{Default value}{\code{rlang::caller_arg(arg)}}
}}

\item{message}{string passed to \code{cli::cli_abort(message)}.
When \code{NULL}, default messaging is used (see examples for default messages).
\code{"{arg_name}"} can be used in messaging.

\describe{
\item{Default value}{\code{NULL}}
}}

\item{class}{Subclass of the condition.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}
}
\value{
The function throws an error if the parameter exists in the input
dataset. Otherwise, the dataset is returned invisibly.
}
\description{
Checks if a parameter (\code{PARAMCD}) does not exist in a dataset.
}
\examples{
library(dplyr)

advs <- tribble(
  ~USUBJID, ~VSTESTCD, ~VSTRESN, ~VSSTRESU, ~PARAMCD, ~AVAL,
  "P01",    "WEIGHT",      80.1, "kg",      "WEIGHT",  80.1,
  "P02",    "WEIGHT",      85.7, "kg",      "WEIGHT",  85.7
)
assert_param_does_not_exist(advs, param = "HR")
try(assert_param_does_not_exist(advs, param = "WEIGHT"))
}
\seealso{
Checks for valid input and returns warning or errors messages:
\code{\link{assert_atomic_vector}()},
\code{\link{assert_character_scalar}()},
\code{\link{assert_character_vector}()},
\code{\link{assert_data_frame}()},
\code{\link{assert_date_vector}()},
\code{\link{assert_expr}()},
\code{\link{assert_expr_list}()},
\code{\link{assert_filter_cond}()},
\code{\link{assert_function}()},
\code{\link{assert_integer_scalar}()},
\code{\link{assert_list_element}()},
\code{\link{assert_list_of}()},
\code{\link{assert_logical_scalar}()},
\code{\link{assert_named}()},
\code{\link{assert_numeric_vector}()},
\code{\link{assert_one_to_one}()},
\code{\link{assert_s3_class}()},
\code{\link{assert_same_type}()},
\code{\link{assert_symbol}()},
\code{\link{assert_unit}()},
\code{\link{assert_vars}()},
\code{\link{assert_varval_list}()}
}
\concept{assertion}
\keyword{assertion}
