% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roclet_rdx.R
\name{rdx_roclet}
\alias{rdx_roclet}
\title{Roclet Extending the Standard rd Roclet}
\usage{
rdx_roclet()
}
\description{
This roclet extends the standard \code{rd} roclet by allowing
\itemize{
\item to add permitted values and default values to the \verb{@param} tag and
\item to add a caption and a description to examples.
}
}
\details{
The following tags are supported:
\itemize{
\item \verb{@permitted}: Permitted values for the argument. Permitted value description
which are used for several arguments/functions can be stored in
\code{inst/roxygen/rdx_meta.R}. For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{list(
  rdx_permitted_values = list(
    mode = "`\\"first\\"`, `\\"last\\"`",
    msg_type = "`\\"none\\"`, `\\"message\\"`, `\\"warning\\"`, `\\"error\\"`"
  )
)
}\if{html}{\out{</div>}}

The reference to the permitted values is done by specifying the name of
the list element in square brackets, e.g., \verb{@permitted [mode]}.
\item \verb{@default}: Default value for the argument. By default the default value
from the function formals is displayed. This can be overwritten by using
the \verb{@default} tag.
\item \verb{@examplesx}: This tag can be used to mark the beginning of the examples
section but doesn't affect the output, i.e., it can be omitted.
\item \verb{@caption}: Caption for the example. The caption is displayed as a subsection
in the examples section. The caption can be followed by an arbitrary number
of \verb{@info} and \verb{@code} tags.
\item \verb{@info}: Description of the example.
\item \verb{@code}: Code of the example.

By default, any warning or error issued by the example code causes the
building of the documentation to fail. If this is expected, the condition
can be added to the \code{expected_cnds} option of the \verb{@code} tag. E.g.,

\if{html}{\out{<div class="sourceCode">}}\preformatted{@code [expected_cnds = "warning"]
}\if{html}{\out{</div>}}
}

To use the roclet call \code{roxygen2::roxygenise(roclets = "admiral::rdx_roclet")} or add to the \code{DESCRIPTION} file:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Roxygen: list(markdown = TRUE, roclets = c("collate", "namespace", "admiraldev::rdx_roclet"))
}\if{html}{\out{</div>}}

For more information on roxygen2 roclets see the \href{https://roxygen2.r-lib.org/articles/extending.html}{Extending roxygen2}.
}
\keyword{documentation}
\section{Examples}{
\subsection{Using the custom tags}{

The id \code{char_scalar} used for the \verb{@permitted} tag is defined in
\code{man/roxygen/rdx_meta.R}.

See \code{\link[=demo_fun]{demo_fun()}} for a rendered version of the \code{Rd} code generated in the
example.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{roxygen2::roc_proc_text(
  rdx_roclet(),
  c(
    "#' A Demo Function",
    "#'",
    "#' This function is used to demonstrate the custom tags of the `rdx_roclet()`.",
    "#'",
    "#' @param x An argument",
    "#' @param number A number",
    "#' @permitted A number",
    "#' @param letter A letter",
    "#' @permitted [char_scalar]",
    "#' @default The first letter of the alphabet",
    "#' @examplesx",
    "#' @caption A simple example",
    "#' @info This is a simple example showing the default behaviour.",
    "#' @code demo_fun(1)",
    "#' @caption An example with a different letter",
    "#' @info This example shows that the `letter` argument doesn't",
    "#'   affect the output. ",
    "#' @code demo_fun(1, letter = \"b\")",
    "demo_fun <- function(x, number = 1, letter = \"a\") 42"
  ))
#> $demo_fun.Rd
#> \% Generated by roxygen2: do not edit by hand
#> \% Please edit documentation in ./<text>
#> \name{demo_fun}
#> \alias{demo_fun}
#> \title{A Demo Function}
#> \usage{
#> demo_fun(x, number = 1, letter = "a")
#> }
#> \arguments{
#> \item{x}{An argument
#> 
#> \describe{
#> \item{Default value}{none}
#> }}
#> 
#> \item{number}{A number
#> 
#> \describe{
#> \item{Permitted values}{A number}
#> \item{Default value}{\code{1}}
#> }}
#> 
#> \item{letter}{A letter
#> 
#> \describe{
#> \item{Permitted values}{a character scalar, i.e., a character vector of length one}
#> \item{Default value}{The first letter of the alphabet}
#> }}
#> }
#> \description{
#> This function is used to demonstrate the custom tags of the \code{rdx_roclet()}.
#> }
#> \section{Examples}{
#> \subsection{A simple example}{
#> 
#> This is a simple example showing the default behaviour.
#> 
#> \if{html}{\out{<div class="sourceCode r">}}\preformatted{demo_fun(1)
#> #> [1] 42}\if{html}{\out{</div>}}}
#> \subsection{An example with a different letter}{
#> 
#> This example shows that the \code{letter} argument doesn't
#> affect the output.
#> 
#> \if{html}{\out{<div class="sourceCode r">}}\preformatted{demo_fun(1, letter = "b")
#> #> [1] 42}\if{html}{\out{</div>}}}}
#> 
#> }\if{html}{\out{</div>}}}}

