% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaps.R
\name{summarise_gaps}
\alias{summarise_gaps}
\title{Summarise Gaps in Therapy}
\usage{
summarise_gaps(.data)
}
\arguments{
\item{.data}{Data to be piped into the function}
}
\value{
A summary of gaps in therapy
}
\description{
This function serves as a convenience wrapper of \code{dplyr::summarise()}, which takes the grouped variables and
summarises their gaps in therapy. This function is to be used after \code{propagate_date()}.
}
\note{
This function relies an \code{adjusted_date} column to identify gaps in therapy. So, if you don't want to use \code{propagate_date()} beforehand,
you'll need to rename the date variable you wish to use to \code{adjusted_date}.
}
\examples{
library(adheRenceRX)
library(dplyr)

toy_claims \%>\% 
  filter(ID == "D") \%>\% 
  propagate_date(.date_var = date, .days_supply_var = days_supply) \%>\% 
  summarise_gaps()



}
