% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial_plan.R
\name{fp_scale}
\alias{fp_scale}
\title{Retrieve the scale of a factor}
\usage{
fp_scale(fp, fct)
}
\arguments{
\item{fp}{The factorial plan object}

\item{fct}{The standard name of the factor as a string (e.g. \code{"A"}, or \code{"B"}, etc.)}
}
\value{
A vector representing the factor range in scaled units; scales
must have been added with \code{fp_add_scale}. If scales are not
available, the range in coded units is returned (i.e. \code{c(-1,1)})
}
\description{
This is a utility function mostly for internal use.
}
\examples{
df <- fp_design_matrix(2) \%>\%
  fp_add_names(A="Temperature", B="Pressure") \%>\%
  fp_add_scale(A=c(20,30), B=c(3, 7))
fp_scale(df, "A")
}
\seealso{
\code{\link[=fp_add_scale]{fp_add_scale()}}
}
