% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorial_plan.R
\name{fp_name}
\alias{fp_name}
\title{Get the full name for a factor}
\usage{
fp_name(fp, fct)
}
\arguments{
\item{fp}{The factorial plan object}

\item{fct}{The standard name of the factor as a string (e.g. \code{"A"}, or \code{"B"}, etc.)}
}
\value{
A string with the factor full name, if available (must have been
added with \code{fp_add_names}). If not, it returns \code{fct} ditto.
}
\description{
This is a utility function mostly for internal use.
}
\examples{
df <- fp_design_matrix(2) \%>\%
  fp_add_names(A="Temperature", B="Pressure")
fp_name(df, "A")
}
\seealso{
\code{\link[=fp_add_names]{fp_add_names()}}
}
