% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helperFunctions.R
\name{weights-actuaRE}
\alias{weights-actuaRE}
\alias{weights.cpglm}
\alias{weights.hierCredGLM}
\alias{weights.hierCredTweedie}
\alias{weights.buhlmannStraubGLM}
\alias{weights.buhlmannStraubTweedie}
\title{Extract the model weights}
\usage{
\method{weights}{cpglm}(object, type = c("prior", "working"), ...)

\method{weights}{hierCredGLM}(object, type = c("prior", "working"), ...)

\method{weights}{hierCredTweedie}(object, type = c("prior", "working"), ...)

\method{weights}{buhlmannStraubGLM}(object, type = c("prior", "working"), ...)

\method{weights}{buhlmannStraubTweedie}(object, type = c("prior", "working"), ...)
}
\arguments{
\item{object}{an object for which the extraction of model weights is meaningful. Can be either \code{\link[cplm]{cpglm}},
\code{\link{glm}}, \code{\link{hierCredibility}}, \code{\link{hierCredGLM}} or \code{\link{hierCredTweedie}}}

\item{type}{indicates if prior or working weights need to be extracted.}

\item{...}{ignored}
}
\value{
Weights extracted from the object \code{object}: the default method looks for component "weights" and if not \code{NULL}
 calls \code{\link[stats]{napredict}} on it.
}
\description{
\code{weights} is a generic function which extracts fitting weights from objects returned by modeling functions.
Methods can make use of \code{\link[stats]{napredict}} methods to compensate for the omission of missing values. The default methods does so.
}
\seealso{
\code{\link[stats]{weights}}, \code{\link[cplm]{cpglm}}, \code{\link{glm}}, \code{\link{hierCredibility}}, \code{\link{hierCredGLM}} or \code{\link{hierCredTweedie}}
}
