% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_flextable_summary.R
\name{create_flextable_summary}
\alias{create_flextable_summary}
\title{Create a formatted table of results}
\usage{
create_flextable_summary(
  results_summary_means,
  results_summary_medians,
  language = c("en", "fr"),
  metrics = c("all", "volume", "step_acc", "int_distri"),
  epoch_label = "60s"
)
}
\arguments{
\item{results_summary_means}{A dataframe with mean results obtained using the \code{\link{prepare_dataset}},  \code{\link{mark_wear_time}}, \code{\link{mark_intensity}}, \code{\link{recap_by_day}}, and then the \code{\link{average_results}} functions.}

\item{results_summary_medians}{A dataframe with median results obtained using the \code{\link{prepare_dataset}},  \code{\link{mark_wear_time}}, \code{\link{mark_intensity}}, \code{\link{recap_by_day}}, and then the \code{\link{average_results}} functions.}

\item{language}{A character value for setting the language with which the figure should be created: \code{en} for english; \code{fr} for french.}

\item{metrics}{A character value for setting the metrics to be shown in the figure. "volume" refers to "activity volume" metrics, step_acc" refers
to "step accumulation" metrics, and "int_distri" refers to intensity distribution metrics. By default, the function provides all computed metrics.}

\item{epoch_label}{A character value to be pasted into the names of the variables to build the figure}
}
\value{
A flextable object
}
\description{
The function generates a formatted table with both means and medians of the metrics obtained following the physical behavior measurement.
}
\examples{
\donttest{
file <- system.file("extdata", "acc.agd", package = "activAnalyzer")
mydata <- prepare_dataset(data = file)
mydata_with_wear_marks <- mark_wear_time(
    dataset = mydata, 
    TS = "TimeStamp", 
    cts  = "vm", 
    frame = 90, 
    allowanceFrame = 2, 
    streamFrame = 30
    )
mydata_with_intensity_marks <- mark_intensity(
    data = mydata_with_wear_marks, 
    col_axis = "vm", 
    equation = "Sasaki et al. (2011) [Adults]",
    sed_cutpoint = 200, 
    mpa_cutpoint = 2690, 
    vpa_cutpoint = 6167, 
    age = 32,
    weight = 67,
    sex = "male",
    )
summary_by_day <- recap_by_day(
    data = mydata_with_intensity_marks, 
    age = 32, 
    weight = 67, 
    sex = "male",
    valid_wear_time_start = "07:00:00",
    valid_wear_time_end = "22:00:00"
    )$df_all_metrics
results_summary_means <- average_results(
    data = summary_by_day, 
    minimum_wear_time = 10, 
    fun = "mean"
    )
results_summary_medians <- average_results(
    data = summary_by_day, 
    minimum_wear_time = 10, 
    fun = "median"
    )
create_flextable_summary(
    results_summary_means,
    results_summary_medians, 
    language = "en"
    )
}

}
