% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abwm.test.R
\name{abwm.test}
\alias{abwm.test}
\title{Ansari-Bradley Test with Arbitrarily Missing Data}
\usage{
abwm.test(X, Y, alternative = c("two.sided", "less", "greater"))
}
\arguments{
\item{X, Y}{numeric vectors of data values with potential missing data.
Inf and -Inf values will be omitted.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "two.sided" (default), "greater" or "less".
You can specify just the initial letter.}
}
\value{
\item{p.value}{the p-value for the test.}

\item{bounds.statistic}{bounds of the value of the Ansari-Bradley
test statistic.}

\item{bounds.pvalue}{bounds of the p-value of the Ansari-Bradley
test.}

\item{alternative}{a character string describing the alternative hypothesis.}

\item{data.name}{a character string giving the names of the data.}
}
\description{
Performs the two-sample Ansari-Bradley test for univariate, distinct
data in the presence of missing values with controlled Type I error.
}
\details{
\code{abwm.test()} performs the Ansari-Bradley scale testing method
(Ansari & Bradley, 1960) in the presence of missing data, as described in Zeng et al. (2025).
Suppose \eqn{X = \{x_{1}, \ldots, x_{n}\}} and \eqn{Y = \{y_{1}, \ldots, y_{m}\}},
the Ansari-Bradley test statistic in Zeng et al. (2025) is defined as
\deqn{\sum_{i = 1}^{n} \left|R(x_i, X \cup Y) - \frac{n + m + 1}{2}\right|,}
where \eqn{R(x_i, X \cup Y)} denotes the rank of \eqn{x_i} in the set
\eqn{X \cup Y}. The function \code{abwm.test()} returns the tight bounds of
the Ansari-Bradley test statistic and its p-value obtained using the normal approximation.
The p-value of the test method proposed in Zeng et al. (2025) is then
returned as the maximum possible p-value of the Ansari-Bradley test.
This method (Zeng et al., 2025) does not make any missing data assumptions, and
controls the Type I error regardless of the values
of missing data.
}
\examples{
#### Assume all values are distinct.
X <- c(6.2, 3.5, NA, 7.6, 9.2)
Y <- c(0.2, 1.3, -0.5, -1.7)

## Perform the two-sided Ansari-Bradley testing with missing data.
abwm.test(X, Y, alternative = 'two.sided')

## Consider one-sided testing.
abwm.test(X, Y, alternative = 'less')
}
\references{
\itemize{
\item Y. Zeng, N. M. Adams, D. A. Bodenham. Scale two-sample testing with
arbitrarily missing data. arXiv preprint arXiv:2509.20332. 2025.

\item A. R. Ansari, R. A. Bradley. Rank-Sum Tests for Dispersions.
\emph{The Annals of Mathematical Statistics}, pages 1174–1189, 1960.

}
}
\seealso{
\code{\link[stats:ansari.test]{stats::ansari.test()}} when data are completely observed.
}
