### Perform Ansari-Bradley Test in the presence of missing data.
AnsariBradleyTestMissingData <- function(X,Y,min_AnsariBradley, max_AnsariBradley,
                                         alternative){
  # return p-value
  n <- length(X)
  m <- length(Y)
  N <- n + m
  if(N%%2 == 0){
    mu <- 0.25*n*N
    sigma <- sqrt(m*n*(N^2-4)/(48*(N-1)))
  }else{
    mu <- 0.25*n*(N^2-1)/N
    sigma <- sqrt(m*n*(N+1)*(N^2+3)/(48*N^2))
  }

  if (alternative == 'less'){
    return (c(stats::pnorm(min_AnsariBradley, mu, sigma), stats::pnorm(max_AnsariBradley, mu, sigma)))
  }else if (alternative == 'greater'){
    return (c(1 - stats::pnorm(max_AnsariBradley, mu, sigma), 1 - stats::pnorm(min_AnsariBradley, mu, sigma)))
  }else{
    p_1 <- 2*min(stats::pnorm(min_AnsariBradley, mu, sigma), 1- stats::pnorm(min_AnsariBradley, mu, sigma))
    p_2 <- 2*min(stats::pnorm(max_AnsariBradley, mu, sigma), 1- stats::pnorm(max_AnsariBradley, mu, sigma))
    p_min <- min(p_1, p_2)
    if((min_AnsariBradley - mu)*(max_AnsariBradley - mu) <= 0){
      p_max <- 1
    }else{
      p_max <- max(p_1,p_2)
    }
    return(c(p_min, p_max))
  }
}



