% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/montlake_buildings.R
\name{montlake_buildings}
\alias{montlake_buildings}
\title{Example OSM Buildings Table for Montlake}
\format{
A sf dataframe with columns:
\describe{
\item{osm_way_id}{OSM ID assigned to each building.}
\item{name}{OSM name assigned to each building (might be NA).}
\item{building}{OSM building category assigned to each building.}
\item{geometry}{Simple feature collection (sfc) contain multipolygons,
each representing the boundaries of a building.}
}
}
\source{
OpenStreetMap
}
\description{
Each row of this table contains a building that exists within a
zone in the \code{montlake_zones} table.
}
\details{
These buildings were retrieved using \code{osmextract::oe_read()}. See the code used to
create this data in \href{https://github.com/a-b-street/abstr/blob/main/data-raw/montlake-test-data.R}{\code{data-raw/montlake-test-data.R}}.
}
\examples{
library(sf)
names(montlake_buildings)
head(montlake_buildings$osm_way_id)
head(montlake_buildings$name)
head(montlake_buildings$building)
nrow(montlake_buildings)
plot(montlake_buildings)
}
