% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deficient.R
\name{Deficient}
\alias{Deficient}
\alias{A005100}
\title{Deficient numbers}
\usage{
Deficient(n, gmp = TRUE)
}
\arguments{
\item{n}{the number of first \code{n} entries from the sequence.}

\item{gmp}{a logical; \code{TRUE} to use large number representation, \code{FALSE} otherwise.}
}
\value{
a vector of length \code{n} containing first entries from the sequence.
}
\description{
Under OEIS \href{https://oeis.org/A005100}{A005100}, a \emph{deficient} number is
a number whose proper divisors sum up to the extent smaller than the number itself. First
6 deficient numbers are 	1, 2, 3, 4, 5, 7
}
\examples{
\donttest{
## generate first 30 Deficient numbers
print(Deficient(30))
}

}
\seealso{
\code{\link{Abundant}}, \code{\link{Perfect}}
}
