% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_AI.R
\name{compute_AI}
\alias{compute_AI}
\title{The brain asymmetry index (AI)}
\usage{
compute_AI(
  data = sample_data,
  left_hemisphere = "lh",
  right_hemisphere = "rh",
  separator = "_",
  ID = "ID",
  hemisphere = "prefix",
  start,
  end
)
}
\arguments{
\item{data}{The wide format data}

\item{left_hemisphere}{The prefix or suffix that indicates the left hemisphere in the variable names}

\item{right_hemisphere}{The prefix or suffix string that indicates the right hemisphere in the variable names}

\item{separator}{A character vector that separates characters in the variable names.}

\item{ID}{The column of identifiers.}

\item{hemisphere}{The character vector that indicates whether a hemisphere indicator in the variable names is a prefix or suffix.}

\item{start}{The column that specifies the starting point of a set of variables to calculate the AIs.}

\item{end}{The column that specifies the endpoint of a set of variables to calculate the AIs.}
}
\value{
The data with AIs.
}
\description{
AI formula = [(left-right)/(left+right)].
compute_AI() creates new columns that are AIs of the brain measures using the most widely-used formula.
}
\examples{

data(sample_data)

compute_AI(sample_data,
left_hemisphere = "lh",
right_hemisphere = "rh",
separator="_",
ID="ID",
hemisphere="prefix",
start="lh_Thalamus",
end="rh_AccumbensArea")
}
