% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gellerman_series.R
\name{gell_like}
\alias{gell_like}
\title{Gellerman-like series}
\usage{
gell_like(n)
}
\arguments{
\item{n}{numeric, a vector of 0 and 1 (see Details)}
}
\value{
a numeric vector of randomly distributed 0s and 1s
}
\description{
Gellerman-like series
}
\details{
The algorithm implements a Gellerman-like series based on
Herrera, D., & Treviño, M. (2015). http://doi.org/10.1371/journal.pone.0136084
The algorithm samples from a binomial distribution and imposes two restrictions
\enumerate{
\item no more than 3 consecutive values of 0s or 1s.
\item the number of trials 0 or 1 must be the same for a given n.
}
}
\examples{
set.seed(165)
gell_like(8) # 0 0 1 1 1 0 1 0
}
