% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwhm.r
\name{fwhm}
\alias{fwhm}
\title{Full Width at Half Maximum}
\usage{
fwhm(x, y)
}
\arguments{
\item{x}{numeric, a vector of values from a distribution (density)}

\item{y}{numeric, a vector of probabilities}
}
\value{
a list with the fwhm and the x at which the max ocurred
}
\description{
Full Width at Half Maximum
}
\details{
The function allows to compute the spread of a symmetric function
even when it is not normally distributed. It first finds the x at which y is max,
then
x1 and x2 can be recovered using x1=peak-fwhm/2, x2=peak+fwhm/2
}
\examples{
set.seed(170)
rx <- rnorm(100)
den <- density(rx)
fval <- fwhm(den$x, den$y)
x1 <- fval$peak - fval$fwhm / 2
x2 <- fval$peak + fval$fwhm / 2
plot(den)
abline(v = c(x1, fval$peak, x2), col = c(1, 2, 1))

}
