% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exhaustive_lhl.r
\name{exhaustive_lhl}
\alias{exhaustive_lhl}
\title{Individual trial analysis for peak procedure data}
\usage{
exhaustive_lhl(r_times, trial_duration)
}
\arguments{
\item{r_times}{numeric, the times that a response was emitted in a trial}

\item{trial_duration}{numeric, the peak trial duration}
}
\value{
a data.frame of start, stop, spread, middle time (mid) and the response
rate at each state (r1 for low, r2 for high and r3 for the second low rate state)
}
\description{
Individual trial analysis for peak procedure data
}
\examples{
data("r_times")
trial_duration <- max(r_times) |> ceiling() # 180
bps <- exhaustive_lhl(r_times, trial_duration)
plot(
  density(
    r_times,
    adjust = 0.8,
    from = 0,
    to = 180
  ),
  main = "",
  ylab = expression(italic(p(t[R]))),
  xlab = "time in peak trial"
)
abline(v = 60, lty = 2)
bps <- exhaustive_lhl(r_times, 180)
abline(v = c(bps$start, bps$stop), col = 2, lty = 2, lwd = 2)
# compare it with fwhm
den <- density(r_times, from = 0, to = trial_duration)
fval <- fwhm(den$x, den$y)
x1 <- fval$peak - fval$fwhm / 2
x2 <- fval$peak + fval$fwhm / 2
plot(den)
abline(v = c(x1, fval$peak, x2), col = c("blue", 1, "blue"))
}
