\name{seqnull}
\alias{seqnull}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Generate nonclustered sequence data according to different null models. 
}
\description{
 This function generates sequence data that is similar to the original sequence data, but nonclusterd on specific aspects related to the sequencing, timing or time spend in the different states. The function is typically used by only specifying a model among \code{"combined"}, \code{"duration"}, \code{"sequencing"}, \code{"stateindep"} or 
    \code{"Markov"}. The \code{"userpos"} model allows to fully specify a sequence generating model using a starting distribution and a transition rate matrix.
}
\usage{
seqnull(seqdata, model = c("combined", "duration", "sequencing", 
        "stateindep", "Markov", "userpos"), imp.trans = NULL, 
		imp.trans.limit = -1, trate = "trate", begin = "freq", 
		time.varying = TRUE, weighted = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{seqdata}{
State sequence object of class \code{stslist}.
    The sequence data to use.
    Use \code{\link[TraMineR]{seqdef}} to create such an object.
}
  \item{model}{
	 String.
    The model used to generate the nonclustered data. It can be one of \code{"combined"}, \code{"duration"}, \code{"sequencing"}, \code{"stateindep"},
    \code{"Markov"} or \code{"userpos"}. See the Details section.
}
  \item{imp.trans}{
	Optional named character vector listing impossible transitions. Names indicates starting states, while value destinations. Only used for \code{"combined"}, \code{"duration"} and \code{"sequencing"} models.
}
  \item{imp.trans.limit}{
	Numeric. Optional. All transitions with a transition rates below (or equal) this value are considered impossible. Only used for \code{"combined"}, \code{"duration"} and \code{"sequencing"} models.
  }
  \item{trate}{
  String, matrix or array. Only used to specify the \code{"userpos"} model. It can be either a method to compute the time-varying transition rates, a matrix of transition rates used for all time points, or a time-varying transition rates matrix specified as an array. String values \code{"freq"} to use state distribution or \code{"trate"} to use transition rates.
}
  \item{begin}{
	String or vector. Only used to specify the \code{"userpos"} model. Either a vector of probability for the first state in the sequence, or a method to compute it. String values \code{"freq"} to use state distribution at first time point or \code{"ofreq"} to use the overall (time-independent) state distribution.
}
  \item{time.varying}{
	Logical. If \code{TRUE}, the state distribution or the transition rate specified by the \code{trate} arguement (using a string) are computed separately for each time point. 
}
  \item{weighted}{
	Logicel. If \code{TRUE}, state distribution and transition rates are computed using the weights specified in \code{seqdata}.
}
}
\details{
	 This function generates sequence data that is similar to the original sequence data, but nonclusterd on specific aspects related to the sequencing, timing or time spend in the different states. The function is typically used by only specifying a model among \code{"combined"}, \code{"duration"}, \code{"sequencing"}, \code{"stateindep"} or 
    \code{"Markov"}. The models are shortly described below. More information about their usefulness can be found in Studer (2021) (see below).
	
	The \code{"combined"}, \code{"duration"} and \code{"sequencing"} models generate sequence in spell format, by generating a vector of state and their attached durations. The \code{"combined"} model generate random sequencing and duration. The \code{"duration"} model only randomizes duration, while keeping the original sequencing of the states found in the data. Finally, the \code{"sequencing"} only randomizes the sequencing of the states and keep the time spent in a state as found in the data. 
	
	The \code{"stateindep"} model generate sequence by randomly selecting a state at each time point without taking into account the previous one. It can generate highly unlikely sequence because it doesn't account for coherence of trajectories over time. 
	
	The \code{"Markov"} model use a time-invariant (homogeneouns) transition rate matrix to generate the sequences. It can reveals difference in the timing of transitions.
}

\value{
	A state sequence object of class \code{stslist}.
}
\references{
Studer, M. (2021). Validating Sequence Analysis Typologies Using Parametric Bootstrap. \emph{Sociological Methodology}. \doi{10.1177/00811750211014232}
}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
	See Also \code{\link{seqnullcqi}}. 
}
\examples{

data(biofam)

bf.seq <- seqdef(biofam[1:200,10:25])

##Plot the sequences generated by different null models.
seqdplot(seqnull(bf.seq, model="combined"))

seqdplot(seqnull(bf.seq, model="duration"))

seqdplot(seqnull(bf.seq, model="sequencing"))

seqdplot(seqnull(bf.seq, model="stateindep"))

seqdplot(seqnull(bf.seq, model="Markov"))

}
