% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchor2time.R
\name{anchor2time}
\alias{anchor2time}
\title{Convert a proxy record to the time domain using anchor points}
\usage{
anchor2time(
  anchor_points = NULL,
  data = NULL,
  genplot = FALSE,
  keep_editable = FALSE
)
}
\arguments{
\item{anchor_points}{Anchor points made using the \code{\link{astro_anchor}} function or a matrix in which the first column is depth
and the second column is time.}

\item{data}{Data set which needs to be converted from the depth to time domain using set anchor points.
The data set should consist of a matrix with 2 column the first column should be depth
and the second column should be a proxy value.}

\item{genplot}{If  \code{genplot=FALSE} then 3 plots stacked on top of each other will be plotted.
Plot 1: the original data set
Plot 2: the depth time plot
Plot 3: the data set in the time domain
set to TRUE to allow for anchoring using the GUI}

\item{keep_editable}{Keep option to add extra features after plotting  \code{Default=FALSE}}
}
\value{
The output is a matrix with 2 columns.
The first column is time.
The second column sedimentation proxy value.

If \code{genplot=TRUE} then 3 plots stacked on top of each other will be plotted.
Plot 1: the original data set.
Plot 2: the depth time plot.
Plot 3: the data set in the time domain.
}
\description{
Convert a proxy record to the time domain using anchor points made using the \code{\link{astro_anchor}} function.
}
\examples{
# Use the age_model_zeeden example anchor points of Zeeden et al., (2013)
#to anchor the grey data set of Zeeden et al., (2013) in the time domain.

grey_time <- anchor2time(anchor_points=age_model_zeeden,
data=grey,
genplot=FALSE,
keep_editable=FALSE)

}
