% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WallomicsData-package.R
\docType{data}
\name{Metadata}
\alias{Metadata}
\title{Metadata}
\format{
A data frame with 474 rows and 4 variables:
\itemize{
\item \strong{Acc_number}: GenBank accession number (gene name)
\item \strong{Functional_classes}: Functional classes of the CWPs
\item \strong{Protein_families}: Protein families of the CWPs
\item \strong{Putative_functions}: Putative functions of the CWPs
}
}
\source{
\doi{10.3390/cells9102249}
}
\usage{
data("Metadata")
}
\description{
Bioinformatics Annotation and description, using the WallProtDB database, of all the Cell Wall Proteins (CWPs)
identified on rosettes and floral stems of five \emph{A. thaliana} genotypes at two growth temperatures.
See \link{Ecotype} and \link{Temperature} for additionnal information.
}
\examples{
# Load the dataset
data("Metadata")

# Look at the dataset's dimensions
dim(Metadata)
head(Metadata)

# How many functional classes ?
table(Metadata$Functional_classes)

# How many protein families ?
table(Metadata$Protein_families)

}
\keyword{datasets}
