% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{WH}
\alias{WH}
\title{Whittaker-Henderson Smoothing}
\usage{
WH(d, ec, lambda = NULL, q = 2, criterion, reg, y, wt, verbose = 1, ...)
}
\arguments{
\item{d}{Vector / matrix of observed events whose elements should be named.}

\item{ec}{Vector / matrix of central exposure. The central exposure
corresponds to the sum of the exposure period over the insured population.
An individual experiencing an event of interest during the year will no
longer be exposed afterwards and the exposure should be reduced
accordingly.}

\item{lambda}{Smoothing parameter. If missing, an optimization procedure will
be used to find the optimal smoothing parameter.}

\item{q}{Order of penalization. Polynoms of degrees \code{q - 1} are considered
smooth and therefore unpenalized. The default of \code{2} should be suitable for
most practical applications. Higher orders may cause numerical issues.}

\item{criterion}{Criterion to be used for the selection of the optimal
smoothing parameter. Default is \code{"REML"} which stands for restricted
maximum likelihood. Other options include \code{"AIC"}, \code{"BIC"} and \code{"GCV"}.}

\item{reg}{Should an approximate regression framework be used ?
framework.}

\item{y}{Optional vector of observations whose elements should be named. Used
only in the regression framework and even in this case will be
automatically computed from the \code{d} and \code{ec} arguments if those are
supplied. May be useful when using Whittaker-Henderson smoothing outside of
the survival analysis framework.}

\item{wt}{Optional vector / matrix of weights. As for the observation vector
/ matrix \code{y}, used only in the regression framework and even in this case
will be automatically computed if the \code{d} argument is supplied. May be
useful when using Whittaker-Henderson smoothing outside of the survival
analysis framework.}

\item{verbose}{Integer between 0 and 3. Control the level of informations
that will be printed on screen during fitting.}

\item{...}{Additional parameters passed to the smoothing function called.}
}
\value{
An object of class \code{WH_1d} i.e. a list containing, among other
things :
\itemize{
\item \code{y} The observation vector/matrix, either supplied or computed as y = log(d) - log(ec)
\item \code{y_hat} The vector/matrix of fitted value
\item \code{std_y_hat} The vector/matrix of standard deviation associated with the fitted value
\item \code{res} The vector/matrix of model deviance residuals
\item \code{edf} The vector/matrix of effective degrees of freedom associated with each observation
\item \code{diagnosis} A data.frame with one row containing the effective degrees of freedom of the model,
the deviance of the fit as well as the AIC, BIC, GCV and REML criteria
}
}
\description{
Main package function to apply Whittaker-Henderson Smoothing in a survival
analysis framework. It takes as input two vectors / matrices of observed
events and associated central exposure and estimate a smooth version of the
log-hazard rate. Smoothing parameters may be supplied or automatically chosen
according to a specific criterion such as \code{"REML"} (recommended), \code{"AIC"},
\code{"BIC"} or \code{"GCV"}. Whittaker-Henderson Smoothing may be applied in a full
maximum likelihood framework (strongly recommended) or an asymptotic
(approximate) Gaussian framework.
}
\examples{

d <- portfolio_mort$d
ec <- portfolio_mort$ec

y <- log(d / ec)
y[d == 0 | ec == 0] <- NA
wt <- d

# Maximum likelihood
WH(d, ec) # automatic smoothing parameter selection via REML
WH(d, ec, lambda = 1e2) # fixed smoothing parameter
WH(d, ec, criterion = "GCV") # alternative criterion for smoothing parameter selection

# Regression
WH(y = y, wt = wt) # regression framework is default when y is supplied
WH(d, ec, reg = TRUE, lambda = 1e2) # forces computation of y from d and ec

}
