% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_inversion_lut.R
\name{sm_inversion_lut}
\alias{sm_inversion_lut}
\title{Inversion of SM from look up table generated by WCM}
\usage{
sm_inversion_lut(img, lookuptable)
}
\arguments{
\item{img}{raster object}

\item{lookuptable}{Look up table simulated from 'wcm_sim' function}
}
\value{
a raster object (pixel value represents SM)
}
\description{
Inversion of SM from look up table generated by WCM
}
\examples{
radar1 <- raster::raster(ncol=10, nrow=10)
val <- seq(-12,-7, length.out=100)
radar1[] <- val
A= -9.596695
B= -0.005331
C= -11.758309
D=  0.011344
lut1 <- lut_wcm(LAI=seq(1,6,0.1), SM=seq(0,.6,.01),coeff=c(A,B,C,D))
example(out_sm <- sm_inversion_lut(img = radar1,lookuptable = lut1))
}
