% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwise_VT.R
\name{pic.calc}
\alias{pic.calc}
\title{Calculate PIC}
\usage{
pic.calc(
  X,
  Y,
  Z,
  mode,
  wf,
  J,
  method = "dwt",
  pad = "zero",
  boundary = "periodic",
  cov.opt = "auto",
  flag = "biased",
  detrend = F
)
}
\arguments{
\item{X}{A vector of response.}

\item{Y}{A matrix of new predictors.}

\item{Z}{A matrix of pre-existing predictors that could be NULL if no prior predictors exist.}

\item{mode}{A mode of variance transfomration, i.e., MRA, MODWT, or AT}

\item{wf}{Wavelet family}

\item{J}{The maximum decomposition level}

\item{method}{Either "dwt" or "modwt" of MRA.}

\item{pad}{The method used for extend data to dyadic size. Use "per", "zero", or "sym".}

\item{boundary}{Character string specifying the boundary condition. If boundary=="periodic" the default, then the vector you decompose is assumed to be periodic on its defined interval, if boundary=="reflection", the vector beyond its boundaries is assumed to be a symmetric reflection of itself.}

\item{cov.opt}{Options of Covariance matrix sign. Use "pos", "neg", or "auto".}

\item{flag}{Biased or Unbiased variance transformation.}

\item{detrend}{Detrend the input time series or just center, default (F).}
}
\value{
A list of 2 elements: the partial mutual information (pmi), and partial informational correlation (pic).
}
\description{
Calculate PIC
}
\references{
Sharma, A., Mehrotra, R., 2014. An information theoretic alternative to model a natural system using observational information alone. Water Resources Research, 50(1): 650-660.

Galelli S., Humphrey G.B., Maier H.R., Castelletti A., Dandy G.C. and Gibbs M.S. (2014) An evaluation framework for input variable selection algorithms for environmental data-driven models, Environmental Modelling and Software, 62, 33-51, DOI: 10.1016/j.envsoft.2014.08.015.
}
