% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{MemoryCache}
\alias{MemoryCache}
\title{Memory Cache}
\description{
In-memory LRU cache with TTL support

Ultra-low latency, limited by available RAM.
Best for hot data, session data, frequently accessed vectors.
}
\section{Super class}{
\code{\link[VectrixDB:BaseCache]{VectrixDB::BaseCache}} -> \code{MemoryCache}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MemoryCache-new}{\code{MemoryCache$new()}}
\item \href{#method-MemoryCache-get}{\code{MemoryCache$get()}}
\item \href{#method-MemoryCache-set}{\code{MemoryCache$set()}}
\item \href{#method-MemoryCache-delete}{\code{MemoryCache$delete()}}
\item \href{#method-MemoryCache-exists}{\code{MemoryCache$exists()}}
\item \href{#method-MemoryCache-clear}{\code{MemoryCache$clear()}}
\item \href{#method-MemoryCache-size}{\code{MemoryCache$size()}}
\item \href{#method-MemoryCache-cleanup_expired}{\code{MemoryCache$cleanup_expired()}}
\item \href{#method-MemoryCache-clone}{\code{MemoryCache$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="delete_many"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-delete_many'><code>VectrixDB::BaseCache$delete_many()</code></a></span></li>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="get_many"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-get_many'><code>VectrixDB::BaseCache$get_many()</code></a></span></li>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="make_key"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-make_key'><code>VectrixDB::BaseCache$make_key()</code></a></span></li>
<li><span class="pkg-link" data-pkg="VectrixDB" data-topic="BaseCache" data-id="set_many"><a href='../../VectrixDB/html/BaseCache.html#method-BaseCache-set_many'><code>VectrixDB::BaseCache$set_many()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MemoryCache-new"></a>}}
\if{latex}{\out{\hypertarget{method-MemoryCache-new}{}}}
\subsection{Method \code{new()}}{
Create a new MemoryCache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MemoryCache$new(config = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{config}}{CacheConfig object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MemoryCache-get"></a>}}
\if{latex}{\out{\hypertarget{method-MemoryCache-get}{}}}
\subsection{Method \code{get()}}{
Get value from cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MemoryCache$get(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Value or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MemoryCache-set"></a>}}
\if{latex}{\out{\hypertarget{method-MemoryCache-set}{}}}
\subsection{Method \code{set()}}{
Set value in cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MemoryCache$set(key, value, ttl = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}

\item{\code{value}}{Value to cache}

\item{\code{ttl}}{Time to live}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MemoryCache-delete"></a>}}
\if{latex}{\out{\hypertarget{method-MemoryCache-delete}{}}}
\subsection{Method \code{delete()}}{
Delete key from cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MemoryCache$delete(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical success
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MemoryCache-exists"></a>}}
\if{latex}{\out{\hypertarget{method-MemoryCache-exists}{}}}
\subsection{Method \code{exists()}}{
Check if key exists
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MemoryCache$exists(key)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{Cache key}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Logical
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MemoryCache-clear"></a>}}
\if{latex}{\out{\hypertarget{method-MemoryCache-clear}{}}}
\subsection{Method \code{clear()}}{
Clear cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MemoryCache$clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MemoryCache-size"></a>}}
\if{latex}{\out{\hypertarget{method-MemoryCache-size}{}}}
\subsection{Method \code{size()}}{
Get cache size
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MemoryCache$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MemoryCache-cleanup_expired"></a>}}
\if{latex}{\out{\hypertarget{method-MemoryCache-cleanup_expired}{}}}
\subsection{Method \code{cleanup_expired()}}{
Cleanup expired entries
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MemoryCache$cleanup_expired()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer count removed
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MemoryCache-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MemoryCache-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MemoryCache$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
