% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hnsw.R
\name{HNSWIndex}
\alias{HNSWIndex}
\title{HNSW Index}
\description{
High-performance approximate nearest neighbor index
}
\examples{
\dontrun{
# Create index
index <- HNSWIndex$new(dimension = 128, metric = "angular")

# Add vectors
index$add_items(ids = c("a", "b", "c"),
                vectors = matrix(rnorm(384), nrow = 3))

# Search
results <- index$search(query = rnorm(128), k = 5)
}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{dimension}}{Vector dimension}

\item{\code{metric}}{Distance metric}

\item{\code{n_trees}}{Number of trees (for Annoy)}

\item{\code{search_k}}{Search parameter}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HNSWIndex-new}{\code{HNSWIndex$new()}}
\item \href{#method-HNSWIndex-add_items}{\code{HNSWIndex$add_items()}}
\item \href{#method-HNSWIndex-build}{\code{HNSWIndex$build()}}
\item \href{#method-HNSWIndex-search}{\code{HNSWIndex$search()}}
\item \href{#method-HNSWIndex-get_vector}{\code{HNSWIndex$get_vector()}}
\item \href{#method-HNSWIndex-get_ids}{\code{HNSWIndex$get_ids()}}
\item \href{#method-HNSWIndex-size}{\code{HNSWIndex$size()}}
\item \href{#method-HNSWIndex-remove_items}{\code{HNSWIndex$remove_items()}}
\item \href{#method-HNSWIndex-clear}{\code{HNSWIndex$clear()}}
\item \href{#method-HNSWIndex-save}{\code{HNSWIndex$save()}}
\item \href{#method-HNSWIndex-load}{\code{HNSWIndex$load()}}
\item \href{#method-HNSWIndex-clone}{\code{HNSWIndex$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-new"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-new}{}}}
\subsection{Method \code{new()}}{
Create a new HNSWIndex
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$new(dimension, metric = "angular", n_trees = 50, search_k = -1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dimension}}{Vector dimension}

\item{\code{metric}}{Distance metric: "angular", "euclidean", "manhattan", "dot"}

\item{\code{n_trees}}{Number of trees for index (higher = more accuracy)}

\item{\code{search_k}}{Search parameter (higher = more accuracy, -1 = auto)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-add_items"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-add_items}{}}}
\subsection{Method \code{add_items()}}{
Add items to the index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$add_items(ids, vectors)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{Character vector of IDs}

\item{\code{vectors}}{Matrix of vectors (rows = items)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-build"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-build}{}}}
\subsection{Method \code{build()}}{
Build the index (required before searching)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$build()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-search"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-search}{}}}
\subsection{Method \code{search()}}{
Search for nearest neighbors
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$search(query, k = 10, include_distances = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query}}{Query vector}

\item{\code{k}}{Number of neighbors}

\item{\code{include_distances}}{Return distances}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Data frame with id, distance columns
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-get_vector"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-get_vector}{}}}
\subsection{Method \code{get_vector()}}{
Get vector by ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$get_vector(id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Item ID}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Vector or NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-get_ids"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-get_ids}{}}}
\subsection{Method \code{get_ids()}}{
Get all IDs
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$get_ids()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-size"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-size}{}}}
\subsection{Method \code{size()}}{
Get item count
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Integer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-remove_items"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-remove_items}{}}}
\subsection{Method \code{remove_items()}}{
Remove items from index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$remove_items(ids)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{IDs to remove}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-clear"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-clear}{}}}
\subsection{Method \code{clear()}}{
Clear the index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$clear()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-save"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-save}{}}}
\subsection{Method \code{save()}}{
Save index to file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$save(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{File path}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-load"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-load}{}}}
\subsection{Method \code{load()}}{
Load index from file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$load(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{File path}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HNSWIndex-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HNSWIndex-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HNSWIndex$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
