% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simIS.R
\name{sim.IS}
\alias{sim.IS}
\title{Function to apply Importance Sampling Algorithm.}
\usage{
sim.IS(zm, use_pilot_study = TRUE, muis = 1, sis = 1, q.is, ...)
}
\arguments{
\item{zm}{A matrix with dimension d and length n.}

\item{use_pilot_study}{TRUE if user wants to choose muis parameter automatically.}

\item{muis}{mean parameter of the importance density.}

\item{sis}{standard deviation parameter of the importance density.}

\item{q.is}{q function that sim.IS function gets target vectors to apply variance reduction.}

\item{...}{ellipsis parameter. different parameters can be passed depending on the problem.}
}
\value{
Weighted simulated values or weights and simulated values are added to input list depending on the initial input size.
}
\description{
Given matrix input with d dimension, this function applies Importance Sampling algorithm and it chooses the best value of the mean value of the importance density automatically. Performs better in rare event simulation. sim.IS checks the input size and returns elements accordingly. If the input value is a list of one element it only updates the simulated value with importance weight and returns that value. If the input value has a dimension bigger than 1, weight values are added separately as another input of the list.
}
\examples{
 sim.outer(n=1e3, d=3, q.outer = sim.IS,
q.is = myq_asian, K=100, ti=(1:3/12), r=0.03, sigma=0.3, S0=100)

sim.outer(n=1e5, d=4, q.outer=sim.AV, q.av = sim.IS, q.is = myq_asian,
         K=130, ti=(1:4/12), r=0.03, sigma=0.3, S0=100)
}
