% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simGeometricAVG.R
\name{sim.GeometricAvg}
\alias{sim.GeometricAvg}
\title{An Outer Control Variate function for Asian Call Option.}
\usage{
sim.GeometricAvg(zm, q.ga, ...)
}
\arguments{
\item{zm}{A matrix with dimension d and length n.}

\item{q.ga}{q function that sim.GeometricAvg function gets target vectors to apply variance reduction.}

\item{...}{ellipsis parameter. different parameters can be passed depending on the problem.}
}
\value{
Updates Y value which stored in list 'results' and returns the list 'results' with updated Y value.
}
\description{
# Applies geometric average asian call outer control varites algorithm to the simulation. Gets expected value for the control variate using BS_Asian_geom function if IS algorithm is within the framework, the length of the q.ga will be different. Checks if IS algorithm is within the framework and applies IS weight accordingly.
}
\examples{
 sim.outer(n=1e3, d=3, q.outer = sim.GeometricAvg,
q.ga = myq_asian, K=100, ti=(1:3/12), r=0.03, sigma=0.3, S0=100)

sim.outer(n=1e3, d=1, q.outer = sim.AV, q.av = sim.GeometricAvg,
q.ga = myq_asian, K=90, ti=(1:1/12), r=0.03, sigma=0.3, S0=100)

}
