% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsilon.statistic.R
\name{upsilon.statistic}
\alias{upsilon.statistic}
\title{Upsilon Test Statistic for Contingency Tables}
\usage{
upsilon.statistic(x)
}
\arguments{
\item{x}{a matrix or data frame of floating or integer
numbers to specify a contingency table. Entries
must be non-negative.}
}
\value{
The numeric value of Upsilon test statistic \eqn{\Upsilon}.
}
\description{
Calculates the Upsilon test statistic \eqn{\Upsilon}.
}
\details{
The Upsilon test is designed to promote 
 dominant function patterns. In contrast to other
 tests of association to favor all function
 patterns, it is unique in demoting non-dominant
 function patterns.
 
 Null hypothesis (\eqn{H_0}): Row and column variables are 
   statistically independent.
 
 Null population: A discrete uniform distribution,
   where each entry in the table has the same
   probability.

 Null distribution: The Upsilon test statistic 
   asymptotically follows a chi-squared distribution
   with \code{(nrow(x) - 1)(ncol(x) - 1)} degrees of freedom,
   under the null hypothesis on the null population.
   
 See \insertCite{luo2021upsilon}{Upsilon} for full 
 details of the Upsilon test.
}
\examples{
library("Upsilon")

# Create a contingency table
x <- matrix(c(
    0, 3, 0, 
    3, 0, 0), 
  nrow = 2, byrow = TRUE)
print(x)

# Calculate statistic
upsilon.statistic(x)
}
\references{
\insertRef{luo2021upsilon}{Upsilon}
}
\keyword{internal}
